-- Create Level
require 'g_level'
g_level.reset()

lua:create_level(1.0,1.0,1.0,1.0)   --RGBA values are given also

--Init animation
lua_init_texture("particle", "data/images/particle.png",FM_NEAREST,WM_CLAMP,WM_CLAMP,AM_MODULATE)
lua_init_subtexture_animation("particle",4,4,1,14,MODE_LOOP, DIRECTION_FORWARD,0.075)

lua_init_texture("purple_flame", "data/images/purple_flame.png",FM_NEAREST,WM_CLAMP,WM_CLAMP,AM_MODULATE)
lua_init_subtextures("purple_flame",8,1,1,5) -- using a selfmade lua function to initialize
lua:init_animation("purple_flame",MODE_LOOP, DIRECTION_FORWARD)
lua:animation_add_frame("purple_flame","purple_flame_1", 0.125)
lua:animation_add_frame("purple_flame","purple_flame_2", 0.125)
lua:animation_add_frame("purple_flame","purple_flame_3", 0.125)
lua:animation_add_frame("purple_flame","purple_flame_4", 0.125)
lua:animation_add_frame("purple_flame","purple_flame_5", 0.125)


-- Create Layers
-- The index of the layers are auto incremented. This meaning that the first one to add is 0 and rest are in order of appearance...
lua:create_layer(0.0,0.0,BM_DEFAULT)  -- x_scroll , y_scroll, blendmode  -- 0
lua:create_layer(0.2,0.2,BM_DEFAULT) -- 1 = taustavuoret
lua:create_layer(0.4,0.4,BM_DEFAULT) -- 2 = taustamets
lua:create_layer(0.75,0.75,BM_DEFAULT) -- 3 = lhipuita
local parallax_x = 1.0
local parallax_y = 1.0
local kamerapurkka = 1.0;
lua:create_layer(parallax_x,parallax_y,BM_DEFAULT) -- 4
lua:create_layer(parallax_x,parallax_y,BM_DEFAULT) -- 5
lua:create_layer(kamerapurkka , kamerapurkka ,BM_DEFAULT) -- 6 = fysiikka + pelaaja
lua:create_layer(1.0,1.0,BM_DEFAULT) -- 7 = joitain ruoho/kivijuttuja
lua:create_layer(1.1,1.1,BM_DEFAULT) -- 8 = foreground


--Triggers start
lua:create_shape("rectangle",PSC_RECTANGLE,40.0,60.0) -- name, type, width, height
lua:shape_vertex("rectangle",2,120.0,0.0) --name, vertex num, x,y
lua:create_trigger("gate", TT_GATE, "data/scripts/srt_level_finished.lua","",3400.0,123.0) --name, type, on_enter_script, on_leave_scipt,x,y
lua:trigger_shape("gate", TT_GATE, "rectangle") --name, type, shape_name
lua:trigger_add_group_i_belong_to("gate", TT_GATE, "everything") --name, type, group_name
lua:trigger_add_group_can_use_me("gate", TT_GATE, "player") --name, type, group_name
lua:trigger_upload("gate",0) --name
---------------------------------------------
--trigger creatures
--ONE
lua:create_creature("creature", CPT_MOVING_CREATURE, "particle", "", "", "") -- name, type, stand_animation, run_animation, jump_up_animation, jump_down_animation
lua:creature_speed("creature", CPT_MOVING_CREATURE, 300.0) -- name, type, speed
lua:creature_shape("creature",CPT_MOVING_CREATURE,16.0,16.0) --name, type, x,y
lua:creature_color("creature", CPT_MOVING_CREATURE, 1.0, 1.0, 1.0, 1.0) --name, type , rgba
lua:creature_translation("creature", CPT_MOVING_CREATURE, 600.0, 260.0) -- set the player to it's right position

lua:create_shape("creature_rectangle",PSC_RECTANGLE,16.0,16.0) -- name, type, width, height
lua:create_trigger("creature_gate", TT_GATE, "data/scripts/point10.lua","",-100.0,120.0) --name, type, on_enter_script, on_leave_scipt,x,y
lua:trigger_shape("creature_gate", TT_GATE, "creature_rectangle") --name, type, shape_name
lua:trigger_add_group_i_belong_to("creature_gate", TT_GATE, "everything") --name, type, group_name
lua:trigger_add_group_can_use_me("creature_gate", TT_GATE, "player") --name, type, group_name
lua:creature_trigger("creature",CPT_MOVING_CREATURE,"creature_gate",g_level.next_id()) -- name, type, trigger_name

lua:create_pathing_graph(false)         -- is_circular
lua:add_pathing_graph_point(1128.0,10.0);    --x,y
lua:add_pathing_graph_point(664.0,10.0);
lua:create_ai("creature","patrol")  -- creature, state name

g_level.upload("creature",4) 
--TWO
lua:create_creature("creature", CPT_MOVING_CREATURE, "particle", "", "", "") -- name, type, stand_animation, run_animation, jump_up_animation, jump_down_animation
lua:creature_speed("creature", CPT_MOVING_CREATURE, 150.0) -- name, type, speed
lua:creature_shape("creature",CPT_MOVING_CREATURE,16.0,16.0) --name, type, x,y
lua:creature_color("creature", CPT_MOVING_CREATURE, 1.0, 1.0, 1.0, 1.0) --name, type , rgba
lua:creature_translation("creature", CPT_MOVING_CREATURE, 1600.0, 260.0) -- set the player to it's right position

lua:create_shape("creature_rectangle",PSC_RECTANGLE,16.0,16.0) -- name, type, width, height
lua:create_trigger("creature_gate", TT_GATE, "data/scripts/point10.lua","",-100.0,120.0) --name, type, on_enter_script, on_leave_scipt,x,y
lua:trigger_shape("creature_gate", TT_GATE, "creature_rectangle") --name, type, shape_name
lua:trigger_add_group_i_belong_to("creature_gate", TT_GATE, "everything") --name, type, group_name
lua:trigger_add_group_can_use_me("creature_gate", TT_GATE, "player") --name, type, group_name
lua:creature_trigger("creature",CPT_MOVING_CREATURE,"creature_gate",g_level.next_id()) -- name, type, trigger_name

lua:create_pathing_graph(false)         -- is_circular
lua:add_pathing_graph_point(2028.0,10.0);    --x,y
lua:add_pathing_graph_point(1664.0,10.0);
lua:create_ai("creature","runaway")  -- creature, state name

g_level.upload("creature",4) 
--THREE (pig)
lua:create_creature("creature", CPT_MOVING_CREATURE, "purple_flame", "", "", "") -- name, type, stand_animation, run_animation, jump_up_animation, jump_down_animation
lua:creature_speed("creature", CPT_MOVING_CREATURE, 700.0) -- name, type, speed
lua:creature_shape("creature",CPT_MOVING_CREATURE,16.0,16.0) --name, type, x,y
lua:creature_color("creature", CPT_MOVING_CREATURE, 1.0, 1.0, 1.0, 1.0) --name, type , rgba
lua:creature_translation("creature", CPT_MOVING_CREATURE, 2600.0, 260.0) -- set the player to it's right position

lua:create_shape("creature_rectangle",PSC_RECTANGLE,16.0,16.0) -- name, type, width, height
lua:create_trigger("creature_gate", TT_GATE, "data/scripts/srt_kill_player.lua","",-100.0,120.0) --name, type, on_enter_script, on_leave_scipt,x,y
lua:trigger_shape("creature_gate", TT_GATE, "creature_rectangle") --name, type, shape_name
lua:trigger_add_group_i_belong_to("creature_gate", TT_GATE, "everything") --name, type, group_name
lua:trigger_add_group_can_use_me("creature_gate", TT_GATE, "player") --name, type, group_name
lua:creature_trigger("creature",CPT_MOVING_CREATURE,"creature_gate",g_level.next_id()) -- name, type, trigger_name

lua:create_pathing_graph(false)         -- is_circular
lua:add_pathing_graph_point(3028.0,10.0);    --x,y
lua:add_pathing_graph_point(2664.0,10.0);
lua:create_ai("creature","physicalmove")  -- creature, state name

g_level.upload("creature",4) 

--Triggers end

--Segments start
lua:create_segment(-345, -40)
lua:add_segment(40950, -40)

lua:create_segment(3161, -43) --generic, not really used... though has to be there (hox: this is a FEATURE)
--Segments end  

--Player
--INIT PLAYER
lua:do_file("data/scripts/crt_player.lua")
lua:init_camera_binder(-7000.0, 18000.0, -400.0, 500.0) -- left, right, bottom, up
lua:upload_player_to_layer(5)  --index of the layer
lua:creature_translation("player", CPT_PLAYER, 0.0, 260.0) -- set the player to it's right position
--Player end

--INIT POINT SETTINGS
lua:points_reset(20, 5) --par_time (the time to be aimed for, in seconds), max_combo (maximum amount of bats in the map)
lua:add_point_level("poor",10) -- description of success, points
lua:add_point_level("average",50)
lua:add_point_level("good",80)
lua:add_point_level("perfect",100)
lua:add_point_level("insane",150)
lua:timer_start() --starts the timer for the level HOX: HAS TO BE LAST!!!

lua:set_game_state(GS_PLAY) -- sets the game state to menu. thus you are able to use the menu commands